/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignatureComparisonState;", "", "cs", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "typeParameters", "", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "typeSubstitutor", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "callbacks", "Lorg/jetbrains/kotlin/resolve/calls/results/SpecificityComparisonCallbacks;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;Ljava/util/Collection;Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;Lorg/jetbrains/kotlin/resolve/calls/results/SpecificityComparisonCallbacks;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;)V", "isLessSpecific", "", "specificType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "generalType", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nFlatSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSignature.kt\norg/jetbrains/kotlin/resolve/calls/results/FlatSignatureComparisonState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class FlatSignatureComparisonState {
    @NotNull
    private final SimpleConstraintSystem cs;
    @NotNull
    private final Collection<TypeParameterMarker> typeParameters;
    @NotNull
    private final TypeSubstitutorMarker typeSubstitutor;
    @NotNull
    private final SpecificityComparisonCallbacks callbacks;
    @NotNull
    private final TypeSpecificityComparator specificityComparator;

    public FlatSignatureComparisonState(@NotNull SimpleConstraintSystem cs, @NotNull Collection<? extends TypeParameterMarker> typeParameters2, @NotNull TypeSubstitutorMarker typeSubstitutor2, @NotNull SpecificityComparisonCallbacks callbacks, @NotNull TypeSpecificityComparator specificityComparator) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        Intrinsics.checkNotNullParameter(typeSubstitutor2, "typeSubstitutor");
        Intrinsics.checkNotNullParameter(callbacks, "callbacks");
        Intrinsics.checkNotNullParameter(specificityComparator, "specificityComparator");
        this.cs = cs;
        this.typeParameters = typeParameters2;
        this.typeSubstitutor = typeSubstitutor2;
        this.callbacks = callbacks;
        this.specificityComparator = specificityComparator;
    }

    public final boolean isLessSpecific(@NotNull KotlinTypeMarker specificType, @NotNull KotlinTypeMarker generalType) {
        Intrinsics.checkNotNullParameter(specificType, "specificType");
        Intrinsics.checkNotNullParameter(generalType, "generalType");
        if (this.specificityComparator.isDefinitelyLessSpecific(specificType, generalType)) {
            return true;
        }
        if (this.typeParameters.isEmpty() || !MarkerExtensionsKt.dependsOnTypeParameters(generalType, this.cs.getContext(), this.typeParameters)) {
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.cs.getContext(), specificType, generalType, false, 8, null) && !this.callbacks.isNonSubtypeEquallyOrMoreSpecific(specificType, generalType)) {
                return true;
            }
        } else {
            KotlinTypeMarker kotlinTypeMarker;
            KotlinTypeMarker substitutedGeneralType = MarkerExtensionsKt.safeSubstitute(this.typeSubstitutor, this.cs.getContext(), generalType);
            KotlinTypeMarker it = AbstractTypeChecker.prepareType$default(AbstractTypeChecker.INSTANCE, this.cs.getContext(), specificType, false, 4, null);
            boolean bl = false;
            if (this.cs.getCaptureFromArgument()) {
                kotlinTypeMarker = this.cs.getContext().captureFromExpression(it);
                if (kotlinTypeMarker == null) {
                    kotlinTypeMarker = it;
                }
            } else {
                kotlinTypeMarker = it;
            }
            KotlinTypeMarker specificCapturedType = kotlinTypeMarker;
            this.cs.addSubtypeConstraint(specificCapturedType, substitutedGeneralType);
            if (this.cs.hasContradiction()) {
                return true;
            }
        }
        return false;
    }
}

